package gov.va.vinci.dart.db.impl;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import gov.va.vinci.dart.biz.RequestAdminParticipantDocument;
import gov.va.vinci.dart.db.RequestAdminParticipantDocumentDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class RequestAdminParticipantDocumentDAOImpl extends HibernateDAO implements RequestAdminParticipantDocumentDAO {
	
	@Override
	@SuppressWarnings("unchecked")
	public List<RequestAdminParticipantDocument> listByRequestId(final int requestId) {
		Query q = createQuery("from RequestAdminParticipantDocument where requestId=:rid");
		q.setParameter("rid",requestId);
		try {
			return (List<RequestAdminParticipantDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result list then
			return new ArrayList<RequestAdminParticipantDocument>();
		}
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<RequestAdminParticipantDocument> listByDocumentId(final int documentId) {
		Query q = createQuery("from RequestAdminParticipantDocument where documentId=:did");
		q.setParameter("did",documentId);
		try {
			return (List<RequestAdminParticipantDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result list then
			return new ArrayList<RequestAdminParticipantDocument>();
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestAdminParticipantDocument> listByRequestIdAndGroupId(final int requestId, final int groupId) {
		Query q = createQuery("from RequestAdminParticipantDocument where requestId=:rid and groupId=:gid");
		q.setParameter("rid",requestId);
		q.setParameter("gid",groupId);
		try {
			return (List<RequestAdminParticipantDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result list then
			return new ArrayList<RequestAdminParticipantDocument>();
		}
	}

	@Override
	public void save(RequestAdminParticipantDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(document);
	}

	@Override
	public void delete(RequestAdminParticipantDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(document);
	}
}
